import React from "react";
import { View, Text, Pressable, StyleSheet } from "react-native";
import BackIcon from "../../../assets/svgs/backButton.svg";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const BackNavigation = (props) => {
    const { navigationProps, screen = "", routeName, capitalize } = props;

    const splitRouteName = routeName.split(" ");
    const nameArray = splitRouteName.map(
        (cap) => cap.charAt(0).toUpperCase() + cap.slice(1)
    );
    const capitalizeString = nameArray.join(" ");

    const backScreen = () => {
        if (screen) {
            navigationProps.navigate(screen);
        } else {
            navigationProps.goBack();
        }
    };
    return (
        <View style={styles.container}>
            <View style={styles.titleWrap}>
                <Text style={styles.title}>
                    {capitalize ? capitalizeString : routeName.toUpperCase()}
                </Text>
            </View>
            {navigationProps && (
                <Pressable
                    onPress={() => backScreen()}
                    style={styles.iconWrap}
                >
                    <CustomSVG svgIcon={BackIcon} isRtl={1} height={dpr(28)} width={dpr(28)} />
                </Pressable>
            )}
        </View>
    );
};

export default BackNavigation;

const styles = StyleSheet.create({
    container: {
        flexDirection: 'row',
        alignItems: 'center',
        backgroundColor: "#FFFFFF",
        paddingTop: dpr(15),
        paddingBottom: dpr(5),
        minHeight: dpr(64),
    },
    iconWrap: {
        position: "absolute",
        left: dpr(0),
        paddingLeft: dpr(20),
        top: dpr(22),
        height: dpr(30),
        width: dpr(60),
        zIndex: 9999,
        backgroundColor: "rgba(255, 255, 255,0.5)",
    },
    titleWrap: {
        flex: 1,
        textAlign:'center',
    },
    title: {
        textAlign:'center',
        fontSize: dpr(20),
        fontFamily: "DMSans_700Bold",
        color: "#2C2C2C",
        paddingHorizontal: dpr(10),
    }
});
